/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class AutoOrder
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgTarget;
    private final Setting<String> targetItemName;
    private final Setting<class_1792> snipingItem;
    private final Setting<Integer> moveDelay;
    private final Setting<Boolean> chatFeedback;
    private static final int WAIT_TIME = 988;
    private static final int CYCLE_DELAY = 500;
    private static final int TIMEOUT = 2596;
    private Stage stage;
    private long stageStart;
    private String currentTarget;
    private int itemMoveIndex;
    private long lastItemMoveTime;
    private int exitCount;
    private int finalExitCount;
    private long finalExitStart;
    private int cycleCount;

    public AutoOrder() {
        super(CatalystAddon.CATEGORY, "auto-order", "Automatically orders items from the server shop.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgTarget = this.settings.createGroup("Target Item");
        this.targetItemName = this.sgTarget.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Item Name")).description("Name of the item to order")).defaultValue((Object)"diamond")).build());
        this.snipingItem = this.sgTarget.add((Setting)((ItemSetting.Builder)((ItemSetting.Builder)((ItemSetting.Builder)new ItemSetting.Builder().name("Snipping Item")).description("The item to snipe from orders.")).defaultValue((Object)class_1802.field_8162)).build());
        this.moveDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Move delay")).description("Delay between item movements")).defaultValue((Object)10)).min(1).max(100).sliderMax(50).build());
        this.chatFeedback = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Chat Feedback")).description("Show chat feedback messages")).defaultValue((Object)true)).build());
        this.stage = Stage.IDLE;
        this.stageStart = 0L;
        this.currentTarget = "";
        this.itemMoveIndex = 0;
        this.lastItemMoveTime = 0L;
        this.exitCount = 0;
        this.finalExitCount = 0;
        this.finalExitStart = 0L;
        this.cycleCount = 0;
    }

    public void onActivate() {
        if (this.mc.field_1724 == null) {
            this.error("Cannot activate - player is null", new Object[0]);
            this.toggle();
            return;
        }
        this.currentTarget = (String)this.targetItemName.get();
        if (((Boolean)this.chatFeedback.get()).booleanValue()) {
            this.info("Target item set to: %s", new Object[]{this.currentTarget});
        }
        this.stage = Stage.WAIT;
        this.stageStart = System.currentTimeMillis();
        this.cycleCount = 0;
        this.resetMovementState();
        if (((Boolean)this.chatFeedback.get()).booleanValue()) {
            this.info("AutoOrder started - Target: %s", new Object[]{this.currentTarget});
        }
    }

    public void onDeactivate() {
        if (this.mc.field_1755 != null) {
            this.mc.field_1724.method_7346();
        }
        this.stage = Stage.IDLE;
        this.resetMovementState();
        if (((Boolean)this.chatFeedback.get()).booleanValue()) {
            this.info("AutoOrder stopped", new Object[0]);
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        switch (this.stage.ordinal()) {
            case 1: {
                if (now - this.stageStart < 988L) break;
                ChatUtils.sendPlayerMsg((String)("/orders " + this.currentTarget));
                this.stage = Stage.ORDERS;
                this.stageStart = now;
                break;
            }
            case 2: {
                class_437 class_4372 = this.mc.field_1755;
                if (!(class_4372 instanceof class_476)) break;
                class_476 screen = (class_476)class_4372;
                class_1703 handler = screen.method_17577();
                for (class_1735 slot : handler.field_7761) {
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isTargetItem(stack)) continue;
                    this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    this.stage = Stage.ORDERS_SELECT;
                    this.stageStart = now;
                    if (((Boolean)this.chatFeedback.get()).booleanValue()) {
                        this.info("Found and selected: %s", new Object[]{stack.method_7964().getString()});
                    }
                    return;
                }
                if (now - this.stageStart <= 2596L) break;
                this.mc.field_1724.method_7346();
                if (((Boolean)this.chatFeedback.get()).booleanValue()) {
                    this.error("Timeout finding %s, restarting cycle", new Object[]{this.currentTarget});
                }
                this.stage = Stage.WAIT;
                this.stageStart = now;
                break;
            }
            case 3: {
                class_437 handler = this.mc.field_1755;
                if (!(handler instanceof class_476)) break;
                class_476 screen = (class_476)handler;
                handler = screen.method_17577();
                if (this.itemMoveIndex > 35) {
                    this.mc.field_1724.method_7346();
                    this.stage = Stage.ORDERS_CONFIRM;
                    this.stageStart = now;
                    this.itemMoveIndex = 0;
                    return;
                }
                if (now - this.lastItemMoveTime < (long)((Integer)this.moveDelay.get()).intValue()) break;
                class_1799 stack = this.mc.field_1724.method_31548().method_5438(this.itemMoveIndex);
                if (!stack.method_7960() && this.isTargetItem(stack)) {
                    for (class_1735 slot : handler.field_7761) {
                        if (slot.field_7871 == this.mc.field_1724.method_31548() || !slot.method_7677().method_7960()) continue;
                        int invSlot = 36 + this.itemMoveIndex - 9;
                        if (this.itemMoveIndex < 9) {
                            invSlot = this.itemMoveIndex;
                        }
                        this.mc.field_1761.method_2906(handler.field_7763, invSlot, 0, class_1713.field_7794, (class_1657)this.mc.field_1724);
                        this.lastItemMoveTime = now;
                        break;
                    }
                }
                ++this.itemMoveIndex;
                break;
            }
            case 4: {
                if (this.mc.field_1755 != null) break;
                ++this.exitCount;
                if (this.exitCount < 2) {
                    this.mc.field_1724.method_7346();
                    this.stageStart = now;
                    break;
                }
                this.exitCount = 0;
                this.stage = Stage.ORDERS_CONFIRM;
                this.stageStart = now;
                break;
            }
            case 5: {
                class_437 handler = this.mc.field_1755;
                if (!(handler instanceof class_476)) break;
                class_476 screen = (class_476)handler;
                handler = screen.method_17577();
                for (class_1735 slot : handler.field_7761) {
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isConfirmButton(stack)) continue;
                    this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    this.stage = Stage.ORDERS_FINAL_EXIT;
                    this.stageStart = now;
                    this.finalExitCount = 0;
                    this.finalExitStart = now;
                    if (((Boolean)this.chatFeedback.get()).booleanValue()) {
                        this.info("Confirmed order for: %s", new Object[]{this.currentTarget});
                    }
                    return;
                }
                if (now - this.stageStart <= 2596L) break;
                this.mc.field_1724.method_7346();
                if (((Boolean)this.chatFeedback.get()).booleanValue()) {
                    this.error("Timeout on confirm for %s, restarting cycle", new Object[]{this.currentTarget});
                }
                this.stage = Stage.WAIT;
                this.stageStart = now;
                break;
            }
            case 6: {
                if (this.finalExitCount == 0) {
                    if (System.currentTimeMillis() - this.finalExitStart < 500L) break;
                    this.mc.field_1724.method_7346();
                    ++this.finalExitCount;
                    this.finalExitStart = System.currentTimeMillis();
                    break;
                }
                if (this.finalExitCount == 1) {
                    if (System.currentTimeMillis() - this.finalExitStart < 400L) break;
                    this.mc.field_1724.method_7346();
                    ++this.finalExitCount;
                    this.finalExitStart = System.currentTimeMillis();
                    break;
                }
                this.finalExitCount = 0;
                ++this.cycleCount;
                if (!this.hasTargetItemInInventory()) {
                    this.stage = Stage.COMPLETED;
                    if (((Boolean)this.chatFeedback.get()).booleanValue()) {
                        this.info("Completed all cycles - no more %s in inventory", new Object[]{this.currentTarget});
                    }
                    this.toggle();
                    break;
                }
                this.stage = Stage.CYCLE_PAUSE;
                this.stageStart = System.currentTimeMillis();
                if (!((Boolean)this.chatFeedback.get()).booleanValue()) break;
                this.info("Cycle %d completed for: %s", new Object[]{this.cycleCount, this.currentTarget});
                break;
            }
            case 7: {
                if (now - this.stageStart < 500L) break;
                this.stage = Stage.WAIT;
                this.stageStart = now;
                this.resetMovementState();
                if (!((Boolean)this.chatFeedback.get()).booleanValue()) break;
                this.info("Starting cycle %d", new Object[]{this.cycleCount + 1});
            }
        }
    }

    private boolean isTargetItem(class_1799 stack) {
        class_1792 targetItem = (class_1792)this.snipingItem.get();
        if (targetItem != class_1802.field_8162) {
            return stack.method_7909() == targetItem;
        }
        if (this.currentTarget.isEmpty()) {
            return false;
        }
        String stackName = stack.method_7964().getString().toLowerCase();
        return stackName.contains(this.currentTarget.toLowerCase());
    }

    private boolean hasTargetItemInInventory() {
        class_1792 targetItem = (class_1792)this.snipingItem.get();
        if (targetItem == class_1802.field_8162) {
            return false;
        }
        for (int i = 9; i < 36; ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (stack.method_7960() || stack.method_7909() != targetItem) continue;
            return true;
        }
        return false;
    }

    private boolean isConfirmButton(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8581 || stack.method_7909() == class_1802.field_8656 || stack.method_7964().getString().toLowerCase().contains("confirm");
    }

    private void resetMovementState() {
        this.itemMoveIndex = 0;
        this.lastItemMoveTime = 0L;
        this.exitCount = 0;
        this.finalExitCount = 0;
        this.finalExitStart = 0L;
    }

    public String getInfoString() {
        if (!this.isActive()) {
            return null;
        }
        return String.format("%s (%d cycles)", this.currentTarget, this.cycleCount);
    }

    public static enum Stage {
        IDLE,
        WAIT,
        ORDERS,
        ORDERS_SELECT,
        ORDERS_EXIT,
        ORDERS_CONFIRM,
        ORDERS_FINAL_EXIT,
        CYCLE_PAUSE,
        COMPLETED;

    }
}

